import { useState, useEffect } from 'react'
import { motion, AnimatePresence } from 'framer-motion'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import './ImageSlider.css'

const ImageSlider = () => {
  const [currentIndex, setCurrentIndex] = useState(0)
  const images = [
    '/images/equipment-1.jpg',
    '/images/equipment-2.jpg',
    '/images/equipment-3.jpg',
    '/images/equipment-4.jpg'
  ]

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentIndex((prev) => (prev + 1) % images.length)
    }, 3000)

    return () => clearInterval(interval)
  }, [images.length])

  const goToPrevious = () => {
    setCurrentIndex((prev) => (prev - 1 + images.length) % images.length)
  }

  const goToNext = () => {
    setCurrentIndex((prev) => (prev + 1) % images.length)
  }

  const goToSlide = (index) => {
    setCurrentIndex(index)
  }

  return (
    <div className="slider-container-sound">
      <div className="slider-wrapper-sound">
        <AnimatePresence mode="wait">
          <motion.div
            key={currentIndex}
            className="slide-sound"
            initial={{ opacity: 0, scale: 1.1, x: 100 }}
            animate={{ opacity: 1, scale: 1, x: 0 }}
            exit={{ opacity: 0, scale: 0.9, x: -100 }}
            transition={{ duration: 0.6 }}
            style={{
              backgroundImage: `url(${images[currentIndex]})`
            }}
          >
            <div className="slide-overlay-sound"></div>
          </motion.div>
        </AnimatePresence>

        <button className="slider-btn-sound slider-btn-prev-sound" onClick={goToPrevious}>
          <ChevronLeft size={24} strokeWidth={2.5} />
        </button>
        <button className="slider-btn-sound slider-btn-next-sound" onClick={goToNext}>
          <ChevronRight size={24} strokeWidth={2.5} />
        </button>

        <div className="slider-dots-sound">
          {images.map((_, index) => (
            <button
              key={index}
              className={`dot-sound ${index === currentIndex ? 'active' : ''}`}
              onClick={() => goToSlide(index)}
            />
          ))}
        </div>
      </div>
    </div>
  )
}

export default ImageSlider

